/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.rep.RAssoKey;
import com.ibm.hsc.rep.RAssoSchema;
import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;

public class RCimWrapper {
    public static final int ENUM_ASSOCIATORS = 0;
    public static final int ENUM_ASSOCIATOR_NAMES = 1;
    public static final int ENUM_REFERENCES = 2;
    public static final int ENUM_REFERENCE_NAMES = 3;
    public static final int ENUM_CIM_INSTANCE = 4;
    public static final int ENUM_CIM_OBJECT_PATH = 5;
    public static boolean rep_disabled = false;

    private RCimWrapper() {
    }

    public static Object getRValue(CIMProperty cIMProperty) throws RException {
        String string = cIMProperty.getName();
        CIMDataType cIMDataType = cIMProperty.getType();
        CIMValue cIMValue = cIMProperty.getValue();
        Object object = null;
        if (cIMValue != null) {
            object = cIMValue.getValue();
        }
        Object object2 = null;
        if (object != null) {
            switch (cIMDataType.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    object2 = object;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    if (object instanceof Vector) {
                        object2 = ((Vector)object).clone();
                        break;
                    }
                    Class<?> clazz = object.getClass();
                    if (clazz.isArray()) {
                        object2 = ((Object[])object).clone();
                        break;
                    }
                    System.out.println("[TX-REP]Warning: property value does not match its CIMDataType");
                    System.out.println("[TX-REP]property name = " + string);
                    System.out.println("[TX-REP]property value class = " + object.getClass());
                    System.out.println("[TX-REP]property CIMDataType = " + cIMDataType);
                    object2 = object;
                    break;
                }
                default: {
                    System.out.println("[TX-REP]CIMDataType " + cIMDataType.getType() + " Not Supported in HSC Repository.");
                    throw new RException("R_ERR_NOT_SUPPORTED");
                }
            }
        }
        return object2;
    }

    public static Object getCValue(CIMDataType cIMDataType, Object object, String string) throws CIMException {
        RUtils.validateDataType(cIMDataType, object, string);
        Object object2 = null;
        if (object != null) {
            switch (cIMDataType.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    object2 = object;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    if (object instanceof Vector) {
                        object2 = ((Vector)object).clone();
                        break;
                    }
                    Class<?> clazz = object.getClass();
                    if (clazz.isArray()) {
                        object2 = ((Object[])object).clone();
                        break;
                    }
                    System.out.println("[TX-REP]Warning: property value does not match its CIMDataType");
                    System.out.println("[TX-REP]property name = " + string);
                    System.out.println("[TX-REP]property value class = " + object.getClass());
                    System.out.println("[TX-REP]property CIMDataType = " + cIMDataType);
                    object2 = object;
                    break;
                }
                default: {
                    System.out.println("[TX-REP]CIMDataType " + cIMDataType.getType() + " Not Supported in HSC Repository.");
                    throw new HSCCIMException("CIM_ERR_NOT_SUPPORTED");
                }
            }
        }
        return object2;
    }

    public static RObjectId getObjectId(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = cIMObjectPath.getNameSpace();
        try {
            int n = RUtils.getNameSpaceId(string);
            String string2 = cIMObjectPath.getObjectName().toLowerCase();
            if (RUtils.hasClass(string, string2)) {
                int n2 = RUtils.getClassId(string, string2);
                RObject rObject = new RObject(n, n2);
                Vector vector = cIMObjectPath.getKeys();
                for (int i = 0; i < vector.size(); ++i) {
                    CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                    Object object = RCimWrapper.getRValue(cIMProperty);
                    if (object == null) {
                        return null;
                    }
                    rObject.setProperty(cIMProperty.getName(), object);
                }
                return rObject.getObjectId();
            }
            throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
    }

    public static boolean isRObject(CIMObjectPath cIMObjectPath) {
        String string;
        if (rep_disabled) {
            return false;
        }
        String string2 = cIMObjectPath.getNameSpace();
        return RUtils.hasClass(string2, string = cIMObjectPath.getObjectName().toLowerCase());
    }

    public static boolean isRAsso(CIMObjectPath cIMObjectPath) throws CIMException {
        String string;
        if (rep_disabled) {
            return false;
        }
        String string2 = cIMObjectPath.getNameSpace();
        return RUtils.hasAsso(string2, string = cIMObjectPath.getObjectName().toLowerCase());
    }

    public static CIMObjectPath createInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        int n;
        String string = cIMObjectPath.getNameSpace();
        try {
            n = RUtils.getNameSpaceId(string);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        String string2 = cIMInstance.getClassName().toLowerCase();
        if (RCimWrapper.isRObject(cIMObjectPath)) {
            try {
                int n2 = RUtils.getClassId(string, string2);
                RObject rObject = new RObject(n, n2);
                RClassSchema rClassSchema = rObject.getSchema();
                rObject.cimSetInstance(cIMOMHandle, cIMInstance);
                rObject.addInstance();
                cIMObjectPath = rObject.cimGetCIMObjectPath(cIMOMHandle);
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        } else if (RCimWrapper.isRAsso(cIMObjectPath)) {
            try {
                int n3 = RUtils.getAssoId(string, string2);
                RAssoSchema rAssoSchema = RUtils.getAssoSchema(string, n3);
                String string3 = rAssoSchema.getRef1PropName();
                String string4 = rAssoSchema.getRef2PropName();
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty(string4).getValue().getValue();
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath2);
                RObjectId rObjectId2 = RCimWrapper.getObjectId(cIMObjectPath3);
                RObject rObject = rObjectId.getObject();
                RObject rObject2 = rObjectId2.getObject();
                if (rObject == null) {
                    System.out.println("[TX-REP]Object does not exist in Repository: " + cIMObjectPath2);
                    throw new RException("R_ERR_NOT_FOUND");
                }
                if (rObject2 == null) {
                    System.out.println("[TX-REP]Object does not exist in Repository: " + cIMObjectPath3);
                    throw new RException("R_ERR_NOT_FOUND");
                }
                rObject.addLink(rAssoSchema.getRef1LinkId(), rObjectId2);
                rObject2.addLink(rAssoSchema.getRef2LinkId(), rObjectId);
                if (rAssoSchema.hasProperty()) {
                    RAssoKey rAssoKey = new RAssoKey(n, n3, rObjectId, rObjectId2);
                    Hashtable hashtable = rAssoSchema.getAssoPropHash();
                    Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                    Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        CIMDataType cIMDataType = (CIMDataType)hashtable.get(string5);
                        CIMProperty cIMProperty = cIMInstance.getProperty(string5);
                        Object object = RCimWrapper.getRValue(cIMProperty);
                        if (object == null) continue;
                        hashtable3.put(string5, object);
                    }
                    hashtable2.put(rAssoKey, hashtable3);
                }
                cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath.setNameSpace(string);
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        } else {
            throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        }
        return cIMObjectPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        int n;
        String string = cIMObjectPath.getNameSpace();
        try {
            n = RUtils.getNameSpaceId(string);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        String string2 = cIMObjectPath.getObjectName().toLowerCase();
        if (RCimWrapper.isRObject(cIMObjectPath)) {
            try {
                int n2 = RUtils.getClassId(string, string2);
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath);
                RObject rObject = rObjectId.getObject();
                if (rObject != null) {
                    rObject.deleteInstance();
                    return;
                }
                System.out.println("[TX-REP]Trying to delete a object that doesn't exist.");
                return;
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        }
        if (!RCimWrapper.isRAsso(cIMObjectPath)) throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        try {
            Object object;
            int n3 = RUtils.getAssoId(string, string2);
            RAssoSchema rAssoSchema = RUtils.getAssoSchema(string, n3);
            String string3 = rAssoSchema.getRef1PropName();
            String string4 = rAssoSchema.getRef2PropName();
            Vector vector = cIMObjectPath.getKeys();
            RObject rObject = null;
            RObject rObject2 = null;
            RObjectId rObjectId = null;
            RObjectId rObjectId2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                CIMObjectPath cIMObjectPath2;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                object = cIMProperty.getName();
                if (((String)object).equalsIgnoreCase(string3)) {
                    cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                    rObjectId = RCimWrapper.getObjectId(cIMObjectPath2);
                    rObject = rObjectId.getObject();
                    continue;
                }
                if (!((String)object).equalsIgnoreCase(string4)) continue;
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                rObjectId2 = RCimWrapper.getObjectId(cIMObjectPath2);
                rObject2 = rObjectId2.getObject();
            }
            if (rObject != null) {
                rObject.removeLink(rAssoSchema.getRef1LinkId(), rObjectId2);
            } else {
                System.out.println("[TX-REP]RCimWrapper.deleteInstance: obj1 not found!");
            }
            if (rObject2 != null) {
                rObject2.removeLink(rAssoSchema.getRef2LinkId(), rObjectId);
            } else {
                System.out.println("[TX-REP]RCimWrapper.deleteInstance: obj2 not found!");
            }
            if (!rAssoSchema.hasProperty() || rObjectId == null || rObjectId2 == null) return;
            RAssoKey rAssoKey = new RAssoKey(n, n3, rObjectId, rObjectId2);
            Hashtable hashtable = rAssoSchema.getAssoPropHash();
            object = RAssoSchema.getAssoObjHash();
            ((Hashtable)object).remove(rAssoKey);
            return;
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        int n;
        String string = cIMObjectPath.getNameSpace();
        try {
            n = RUtils.getNameSpaceId(string);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        String string2 = cIMObjectPath.getObjectName().toLowerCase();
        if (RCimWrapper.isRObject(cIMObjectPath)) {
            try {
                int n2 = RUtils.getClassId(string, string2);
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath);
                RObject rObject = rObjectId.getObject();
                rObject.cimSetInstance(cIMOMHandle, cIMInstance);
                return;
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        }
        if (!RCimWrapper.isRAsso(cIMObjectPath)) throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        try {
            int n3 = RUtils.getAssoId(string, string2);
            RAssoSchema rAssoSchema = RUtils.getAssoSchema(string, n3);
            if (!rAssoSchema.hasProperty()) return;
            String string3 = rAssoSchema.getRef1PropName();
            String string4 = rAssoSchema.getRef2PropName();
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty(string3).getValue().getValue();
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty(string4).getValue().getValue();
            RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath2);
            RObjectId rObjectId2 = RCimWrapper.getObjectId(cIMObjectPath3);
            RAssoKey rAssoKey = new RAssoKey(n, n3, rObjectId, rObjectId2);
            Hashtable hashtable = rAssoSchema.getAssoPropHash();
            Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                CIMDataType cIMDataType = (CIMDataType)hashtable.get(string5);
                CIMProperty cIMProperty = cIMInstance.getProperty(string5);
                Object object = RCimWrapper.getRValue(cIMProperty);
                if (object == null) continue;
                hashtable3.put(string5, object);
            }
            hashtable2.put(rAssoKey, hashtable3);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new HSCCIMException(throwable);
        }
    }

    public static CIMInstance getInstance(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = cIMObjectPath.getNameSpace();
        try {
            int n = RUtils.getNameSpaceId(string);
            String string2 = cIMObjectPath.getObjectName().toLowerCase();
            if (RCimWrapper.isRObject(cIMObjectPath)) {
                int n2 = RUtils.getClassId(string, string2);
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath);
                RObject rObject = rObjectId.getObject();
                CIMInstance cIMInstance = null;
                if (rObject != null) {
                    cIMInstance = rObject.cimGetInstance(cIMOMHandle);
                }
                return cIMInstance;
            }
            if (RCimWrapper.isRAsso(cIMObjectPath)) {
                Object object;
                Object object2;
                int n3 = RUtils.getAssoId(string, string2);
                RAssoSchema rAssoSchema = RUtils.getAssoSchema(string, n3);
                String string3 = rAssoSchema.getRef1PropName();
                String string4 = rAssoSchema.getRef2PropName();
                int n4 = rAssoSchema.getRef1LinkId();
                int n5 = rAssoSchema.getRef2LinkId();
                CIMObjectPath cIMObjectPath2 = null;
                CIMObjectPath cIMObjectPath3 = null;
                Vector vector = cIMObjectPath.getKeys();
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = (CIMProperty)vector.elementAt(i);
                    object = object2.getName();
                    if (((String)object).equalsIgnoreCase(string3)) {
                        cIMObjectPath2 = (CIMObjectPath)object2.getValue().getValue();
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase(string4)) continue;
                    cIMObjectPath3 = (CIMObjectPath)object2.getValue().getValue();
                }
                if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
                    System.out.println("[TX-REP]None of ref1 and ref2 of the asso can be null.");
                    throw new HSCCIMException("CIM_ERR_NOT_FOUND");
                }
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath2);
                object2 = RCimWrapper.getObjectId(cIMObjectPath3);
                if (rObjectId == null || object2 == null) {
                    System.out.println("[TX-REP]Error in the reference's object paths");
                    throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
                }
                object = rObjectId.getObject();
                RObject rObject = ((RObjectId)object2).getObject();
                if (object == null && rObject == null) {
                    System.out.println("[TX-REP]association not found");
                    throw new HSCCIMException("CIM_ERR_NOT_FOUND");
                }
                String string5 = rAssoSchema.getClassName();
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string5, string);
                CIMInstance cIMInstance = cIMOMHandle.getClass(cIMObjectPath4, false).newInstance();
                cIMInstance.setProperty(string3, new CIMValue((Object)cIMObjectPath2));
                cIMInstance.setProperty(string4, new CIMValue((Object)cIMObjectPath3));
                if (rAssoSchema.hasProperty()) {
                    RAssoKey rAssoKey = new RAssoKey(n, n3, rObjectId, (RObjectId)object2);
                    Hashtable hashtable = rAssoSchema.getAssoPropHash();
                    Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                    Hashtable hashtable3 = (Hashtable)hashtable2.get(rAssoKey);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object object3;
                        String string6 = (String)enumeration.nextElement();
                        CIMDataType cIMDataType = (CIMDataType)hashtable.get(string6);
                        Object var28_34 = null;
                        if (hashtable3 != null) {
                            var28_34 = hashtable3.get(string6);
                        }
                        if ((object3 = RCimWrapper.getCValue(cIMDataType, var28_34, string6)) == null) {
                            cIMInstance.setProperty(string6, null);
                            continue;
                        }
                        cIMInstance.setProperty(string6, new CIMValue(object3));
                    }
                }
                return cIMInstance;
            }
            throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
    }

    public static Vector enumInstances(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, int n) throws CIMException {
        String string = cIMObjectPath.getNameSpace();
        try {
            int n2 = RUtils.getNameSpaceId(string);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        String string2 = cIMObjectPath.getObjectName().toLowerCase();
        if (RCimWrapper.isRObject(cIMObjectPath)) {
            try {
                int n3 = RUtils.getClassId(string, string2);
                RClassSchema rClassSchema = RUtils.getClassSchema(string, n3);
                Hashtable hashtable = rClassSchema.getObjHash();
                Enumeration enumeration = hashtable.elements();
                Vector<Object> vector = new Vector<Object>();
                if (n == 5) {
                    while (enumeration.hasMoreElements()) {
                        RObject rObject = (RObject)enumeration.nextElement();
                        CIMObjectPath cIMObjectPath2 = rObject.cimGetCIMObjectPath(cIMOMHandle);
                        vector.add(cIMObjectPath2);
                    }
                } else if (n == 4) {
                    while (enumeration.hasMoreElements()) {
                        RObject rObject = (RObject)enumeration.nextElement();
                        CIMInstance cIMInstance = rObject.cimGetInstance(cIMOMHandle);
                        vector.add(cIMInstance);
                    }
                }
                return vector;
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        }
        if (RCimWrapper.isRAsso(cIMObjectPath)) {
            try {
                int n4 = RUtils.getAssoId(string, string2);
                RAssoSchema rAssoSchema = RUtils.getAssoSchema(string, n4);
                int n5 = rAssoSchema.getRef1ClassId();
                int n6 = rAssoSchema.getRef1LinkId();
                RClassSchema rClassSchema = RUtils.getClassSchema(string, n5);
                Hashtable hashtable = rClassSchema.getObjHash();
                Enumeration enumeration = hashtable.elements();
                Vector vector = new Vector();
                if (n == 5) {
                    while (enumeration.hasMoreElements()) {
                        RObject rObject = (RObject)enumeration.nextElement();
                        Vector vector2 = rObject.cimGetReferenceNames(cIMOMHandle, n6);
                        vector.addAll(vector2);
                    }
                } else if (n == 4) {
                    while (enumeration.hasMoreElements()) {
                        RObject rObject = (RObject)enumeration.nextElement();
                        Vector vector3 = rObject.cimGetReferences(cIMOMHandle, n6);
                        vector.addAll(vector3);
                    }
                }
                return vector;
            }
            catch (RException rException) {
                rException.printStackTrace();
                throw new HSCCIMException(rException.getID());
            }
        }
        throw new HSCCIMException("CIM_ERR_NOT_FOUND");
    }

    public static Vector associators(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        return RCimWrapper.enumRefs(cIMOMHandle, cIMObjectPath, cIMObjectPath2, 0);
    }

    public static Vector associatorNames(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        return RCimWrapper.enumRefs(cIMOMHandle, cIMObjectPath, cIMObjectPath2, 1);
    }

    public static Vector references(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        return RCimWrapper.enumRefs(cIMOMHandle, cIMObjectPath, cIMObjectPath2, 2);
    }

    public static Vector referenceNames(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        return RCimWrapper.enumRefs(cIMOMHandle, cIMObjectPath, cIMObjectPath2, 3);
    }

    private static Vector enumRefs(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, int n) throws CIMException {
        int n2;
        String string;
        String string2 = cIMObjectPath2.getNameSpace();
        try {
            int n3 = RUtils.getNameSpaceId(string2);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        if (!RCimWrapper.isRObject(cIMObjectPath2) && !RCimWrapper.isRAsso(cIMObjectPath)) {
            throw new HSCCIMException("CIM_ERR_NOT_FOUND");
        }
        RAssoSchema rAssoSchema = null;
        RObject rObject = null;
        try {
            if (cIMObjectPath != null && RUtils.hasAsso(string2, string = cIMObjectPath.getObjectName())) {
                n2 = RUtils.getAssoId(string2, string);
                rAssoSchema = RUtils.getAssoSchema(string2, n2);
            }
            if (cIMObjectPath2 != null) {
                string = cIMObjectPath2.getObjectName();
                RObjectId rObjectId = RCimWrapper.getObjectId(cIMObjectPath2);
                if (rObjectId != null) {
                    rObject = rObjectId.getObject();
                }
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        string = null;
        if (rObject != null) {
            n2 = -1;
            RClassSchema rClassSchema = rObject.getSchema();
            String string3 = rClassSchema.getClassName();
            if (rAssoSchema != null) {
                Vector vector = null;
                Vector vector2 = null;
                if (rAssoSchema.getRef1ClassName().equalsIgnoreCase(string3) && (n2 = rAssoSchema.getRef1LinkId()) != -1) {
                    switch (n) {
                        case 0: {
                            vector = rObject.cimGetAssociators(cIMOMHandle, n2);
                            break;
                        }
                        case 1: {
                            vector = rObject.cimGetAssociatorNames(cIMOMHandle, n2);
                            break;
                        }
                        case 2: {
                            vector = rObject.cimGetReferences(cIMOMHandle, n2);
                            break;
                        }
                        case 3: {
                            vector = rObject.cimGetReferenceNames(cIMOMHandle, n2);
                        }
                    }
                }
                if (rAssoSchema.getRef2ClassName().equalsIgnoreCase(string3) && (n2 = rAssoSchema.getRef2LinkId()) != -1) {
                    switch (n) {
                        case 0: {
                            vector2 = rObject.cimGetAssociators(cIMOMHandle, n2);
                            break;
                        }
                        case 1: {
                            vector2 = rObject.cimGetAssociatorNames(cIMOMHandle, n2);
                            break;
                        }
                        case 2: {
                            vector2 = rObject.cimGetReferences(cIMOMHandle, n2);
                            break;
                        }
                        case 3: {
                            vector2 = rObject.cimGetReferenceNames(cIMOMHandle, n2);
                        }
                    }
                }
                if (vector != null) {
                    string = vector;
                }
                if (vector2 != null) {
                    if (string == null) {
                        string = vector2;
                    } else {
                        ((Vector)((Object)string)).addAll(vector2);
                    }
                }
            } else {
                System.out.println("[TX-REP]enumRefs - assoPath cannot be null");
                throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        return string;
    }

    static {
        try {
            FileReader fileReader = new FileReader("/opt/hsc/data/.rep_disabled");
            rep_disabled = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            rep_disabled = false;
        }
    }
}

